package tcp;
/*
 * DictionaryClient.java
 *
 * Created on October 26, 2004, 3:14 PM
 */

import java.net.*;
import java.io.*;
import java.util.*;
/**
 *
 * @author  garbi
 */
public class DictionaryClient {
    
    public static void main(String[] args) {
        Socket mySession= null;
        PrintWriter out= null;
        BufferedReader in= null;
        BufferedReader stdIn= null;
        String hostName;
        if (args.length < 1) hostName="localhost";
        else hostName= args[0];
        try {
            mySession = new Socket(hostName, 4443);
            out = new PrintWriter(mySession.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(mySession.getInputStream()));
            stdIn = new BufferedReader(new InputStreamReader(System.in));
            String fromServer;
            String fromUser;
            
            System.out.println("Go on, ask the dictionary server!");
            while ( !(fromUser = stdIn.readLine()).equals("quit") ) {
                out.println(fromUser);
                fromServer= in.readLine();
                System.out.println("-> " + fromServer);
            }
            
            out.close();
            in.close();
            stdIn.close();
            mySession.close();
        } catch (UnknownHostException e) {
            System.err.println("Unknown host: " + args[0]);
            System.exit(1);
        } catch (IOException e) {
           
                System.err.println("No server found!");
                System.exit(1);
        }
    }
}
